org 100h ; assume ah=bx=0 sp=-2 bp=0x9?? si=0x100

  mov al,0x93
  int 0x10
  push 0x9ff6
  pop es

M mov ax,0xcccd
  mul di        ; dx = y, dl:ah = x, carry = 1 (almost always)
  sbb word[si],-1   ; decrement [si]=t a few times per frame
  mov ax,0x9f10 ; al = gray ramp, ch = error of last pixel
                ; ah = y centering offset (can be 0x80..0xb7)
K equ $-1 ; K=159
  db 0x00,0xe6
;=add dh,ah

  push dx
  pusha ; [-20   -18   -16   -14   -12-11-10 -9 -8 -7 -6 -5|-4 -3 -2]
        ;   di    si    bp    sp    bl bh dl dh cl ch al ah|dl dh  0
        ;   addr  0x100 0x9?? -4    0  0  ( y )    color   |( y )
        ;                                (x)             ( x )
I fild word[bx-5]
  fabs            ; z=|x|
  fist word[bp+si]

  fidivr word[byte si-0x100+K] ; w=K/z

  fldln2
  fsub st1
  fimul word[si]
  fistp word[bx]  ; v=(0.693-w)*t: accelerate
  and ah,[bx]

  fimul word[bx-4]
  fistp word[bx]  ; u=x*w
  xor ah,[bx]     ; c=xor(u,v)

  mul word[bp+si]
  shr dx,2
  add [bx-7],dx   ; color = 0x10 + c*z/4 + error

  popa
  pop dx

  stosb
  jmp M ; time
